/*
 * Decompiled with CFR 0.152.
 */
package com.agricraft.agricraft.compat.emi;

import com.agricraft.agricraft.api.AgriApi;
import com.agricraft.agricraft.api.codecs.AgriMutation;
import com.agricraft.agricraft.api.genetic.AgriGenome;
import com.agricraft.agricraft.api.plant.AgriPlant;
import com.agricraft.agricraft.common.registry.ModItems;
import com.agricraft.agricraft.compat.emi.CropClippingRecipe;
import com.agricraft.agricraft.compat.emi.CropMutationRecipe;
import com.agricraft.agricraft.compat.emi.CropProduceRecipe;
import com.agricraft.agricraft.compat.emi.CropRequirementRecipe;
import dev.emi.emi.api.EmiEntrypoint;
import dev.emi.emi.api.EmiInitRegistry;
import dev.emi.emi.api.EmiPlugin;
import dev.emi.emi.api.EmiRegistry;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.render.EmiRenderable;
import dev.emi.emi.api.render.EmiTexture;
import dev.emi.emi.api.stack.Comparison;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import java.util.ArrayList;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2960;
import net.minecraft.class_5321;

@EmiEntrypoint
public class AgriCraftEmiPlugin
implements EmiPlugin {
    public static final EmiStack WOODEN_CROP_STICK = EmiStack.of((class_1935)((class_1935)ModItems.WOODEN_CROP_STICKS.get()));
    public static final EmiStack CLIPPER = EmiStack.of((class_1935)((class_1935)ModItems.CLIPPER.get()));
    public static final EmiStack FARMLAND = EmiStack.of((class_1935)class_1802.field_8365);
    public static final EmiTexture TEXTURE = new EmiTexture(new class_2960("agricraft", "textures/gui/jei/crop_mutation.png"), 0, 0, 128, 128, 128, 128, 128, 128);
    public static final EmiRecipeCategory MUTATION_CATEGORY = new EmiRecipeCategory(new class_2960("agricraft", "mutation"), (EmiRenderable)WOODEN_CROP_STICK);
    public static final EmiRecipeCategory PRODUCE_CATEGORY = new EmiRecipeCategory(new class_2960("agricraft", "produce"), (EmiRenderable)WOODEN_CROP_STICK);
    public static final EmiRecipeCategory CLIPPING_CATEGORY = new EmiRecipeCategory(new class_2960("agricraft", "clipping"), (EmiRenderable)CLIPPER);
    public static final EmiRecipeCategory REQUIREMENT_CATEGORY = new EmiRecipeCategory(new class_2960("agricraft", "requirement"), (EmiRenderable)FARMLAND);
    public static final Comparison COMPARE_SEEDS = Comparison.compareData(stack -> {
        AgriGenome genome = AgriGenome.fromNBT(stack.getNbt());
        if (genome != null) {
            return genome.getSpeciesGene().getDominant().trait();
        }
        return "unknown";
    });

    public static Comparison compareSeeds() {
        return COMPARE_SEEDS;
    }

    public static <T> class_2960 prefixedId(class_5321<T> key, String prefix) {
        return new class_2960("agricraft", "/" + prefix + "/" + key.method_29177().toString().replace(":", "/"));
    }

    public void register(EmiRegistry registry) {
        registry.addCategory(MUTATION_CATEGORY);
        registry.addWorkstation(MUTATION_CATEGORY, (EmiIngredient)WOODEN_CROP_STICK);
        registry.addWorkstation(MUTATION_CATEGORY, (EmiIngredient)EmiStack.of((class_1935)((class_1935)ModItems.IRON_CROP_STICKS.get())));
        registry.addWorkstation(MUTATION_CATEGORY, (EmiIngredient)EmiStack.of((class_1935)((class_1935)ModItems.OBSIDIAN_CROP_STICKS.get())));
        EmiStack normalSeed = EmiStack.of((class_1935)((class_1935)ModItems.SEED.get())).comparison(Comparison.compareNbt());
        registry.removeEmiStacks(normalSeed);
        AgriApi.getMutationRegistry().ifPresent(mutations -> mutations.method_29722().forEach(entry -> registry.addRecipe((EmiRecipe)new CropMutationRecipe(AgriCraftEmiPlugin.prefixedId((class_5321)entry.getKey(), "mutations"), (AgriMutation)entry.getValue()))));
        registry.addCategory(PRODUCE_CATEGORY);
        registry.addWorkstation(PRODUCE_CATEGORY, (EmiIngredient)WOODEN_CROP_STICK);
        registry.addWorkstation(PRODUCE_CATEGORY, (EmiIngredient)EmiStack.of((class_1935)((class_1935)ModItems.IRON_CROP_STICKS.get())));
        registry.addWorkstation(PRODUCE_CATEGORY, (EmiIngredient)EmiStack.of((class_1935)((class_1935)ModItems.OBSIDIAN_CROP_STICKS.get())));
        AgriApi.getPlantRegistry().ifPresent(plants -> plants.method_29722().forEach(entry -> {
            ArrayList l = new ArrayList();
            ((AgriPlant)entry.getValue()).getAllPossibleProducts(l::add);
            if (!l.isEmpty()) {
                registry.addRecipe((EmiRecipe)new CropProduceRecipe(AgriCraftEmiPlugin.prefixedId((class_5321)entry.getKey(), "products"), (AgriPlant)entry.getValue()));
            }
        }));
        registry.addCategory(CLIPPING_CATEGORY);
        registry.addWorkstation(CLIPPING_CATEGORY, (EmiIngredient)CLIPPER);
        AgriApi.getPlantRegistry().ifPresent(plants -> plants.method_29722().forEach(entry -> {
            ArrayList l = new ArrayList();
            ((AgriPlant)entry.getValue()).getAllPossibleClipProducts(l::add);
            if (!l.isEmpty()) {
                registry.addRecipe((EmiRecipe)new CropClippingRecipe(AgriCraftEmiPlugin.prefixedId((class_5321)entry.getKey(), "clippings"), (AgriPlant)entry.getValue()));
            }
        }));
        registry.addCategory(REQUIREMENT_CATEGORY);
        registry.addWorkstation(REQUIREMENT_CATEGORY, (EmiIngredient)FARMLAND);
        AgriApi.getPlantRegistry().ifPresent(plants -> plants.method_29722().forEach(entry -> registry.addRecipe((EmiRecipe)new CropRequirementRecipe(AgriCraftEmiPlugin.prefixedId((class_5321)entry.getKey(), "requirements"), (AgriPlant)entry.getValue()))));
    }

    public void initialize(EmiInitRegistry registry) {
        super.initialize(registry);
    }
}

